#ifndef __bonus_h__
#define __bonus_h__

#include <stdlib.h>

#include "ogl.h"
#include <lib3d/util2d/Texture.h>

#define MIN_BONUS_SPAWN_TIME 25
#define AUTO_JUMP_TIME 6

typedef enum eBonusType { BT_HEALTH=0, BT_AMMO, BT_LAST_UNUSED };

class Bonus {

public:
   Bonus();
   ~Bonus();

   void setType(eBonusType t) { type = t; }
   eBonusType getType() { return type; }
   void randomize() { setType((eBonusType)(rand()%BT_LAST_UNUSED)); }
   void setPos(float x,float y) { this->x = x; this->y = y; }
   float getX() { return x; }
   float getY() { return y; }
   void  beginJump(float force) { jumping = true; jumpForce = force; }
   void  endJump() { jumping = false; }

   void update(float dt);
   void render();
   
   static bool firstInit;

protected:

   static Texture *healthTex;
   static Texture *ammoTex;

   eBonusType type;

   float x,y;
   bool jumping;
   float jumpForce;
   double jumpTime;

};


#endif